local COOLDOWN = 25000
local EFFECT_DURATION = 1250
local FIRST_ACTIVATION_DELAY = 5000
local HEALING_AMOUNT = 10
local MAX_CLAW_HEALTH = 120

function main(self)

	local claw = GetClaw()

    if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.soundDelay = 0
		self.timeCounter = GetTime() + FIRST_ACTIVATION_DELAY
		self.timeCounter2 = GetTime()
		self.State = 1
	end

	if self.State == 1 then
		if GetTime() > self.timeCounter and claw.Health < 120 and claw.Health > 0 then
			self.State = 2
		end
	end

	if self.State == 2 then
		if claw.Health == 0 then
			self.timeCounter = GetTime() + self.cooldown/5
			self.State = 1
		else
			local health = claw.Health + HEALING_AMOUNT
			claw.Health = health < MAX_CLAW_HEALTH and health or MAX_CLAW_HEALTH
			self.timeCounter = GetTime() + COOLDOWN
			self.timeCounter2 = GetTime() + EFFECT_DURATION
			self.State = 3
		end
	end

	if self.State == 3 then
		if _CurrentPowerup[0] ~= Powerup.Catnip then
			local rect = claw.MoveRect
			CreateObject{
				X = claw.X + rect.Left + math.random(math.abs(rect.Left - rect.Right)),
				Y = claw.Y + rect.Top + math.random(math.abs(rect.Top - rect.Bottom)),
				Z = claw.Z + 1,
				name = "Sparkle",
				image = "CUSTOM_SPARKLEGREEN"
			}
		end
		if GetTime() > self.timeCounter2 then
			self.State = 1
		end
	end
end



